<?php

namespace App\Http\Controllers;

use App\Http\Requests\RoleRequest;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Hash;

class UserRoleController extends Controller
{

    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        if ($request->has('search')) {
            $keyword = $request->input('search');
            $paginate = false;
            $roles = Role::where('name', 'LIKE', '%' . $keyword . '%')
                ->orderBy('id', 'DESC')->withCount('users')->get();

            return view('role.list', compact('roles', 'paginate'));
        } else {
            $paginate = true;
            $roles = Role::orderBy('id', 'DESC')->withCount('users')->paginate(10)->onEachSide(0);
            return view('role.list', compact('roles', 'paginate'));
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $route_names = get_permissions();
        return view('role.create', compact('route_names'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(RoleRequest $request)
    {
        $permissions = $request->input('permissions');
        $name = $request->input('name');

        if (Role::where('name', $name)->exists()) {
            return redirect()->route('user_role.index')->with('error', 'Role already exists');
        } else {
            // Role does not exist, create it
            $role = Role::create(['name' => $name]);
            $role->syncPermissions($permissions);

            return back()->with('success', 'Saved successfully');
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Role $user_role)
    {
        $route_names = get_permissions();
        return view('role.edit', compact('user_role', 'route_names'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(RoleRequest $request, Role $user_role)
    {
        $permissions = $request->input('permissions');
        $name = $request->input('name');

        $role = Role::find($user_role->id);
        $role->name = $name;
        $role->syncPermissions($permissions);
        $role->save();

        return redirect()->route('user_role.index')->with('success', 'Updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Role $user_role)
    {
        $user_role->delete();
        return redirect()->route('user_role.index')->with('success', 'Deleted successfully');
    }
}